/*
 * Decompiled with CFR 0.152.
 */
package com.dao.util;

import com.dao.util.SetOffIdentInsert;
import com.dto.LoginDto;
import com.utility.CollectionBinder;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.ExceptionUtils;
import com.utility.MyHolooMessageMaker;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.utility.TncLog;
import com.utility.TransactionCheck;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.springframework.lang.Nullable;

public abstract class BulkInsertHelper<T> {
    protected final DbConnection dbConnection;
    private List<Map<String, Object>> callApiResult;
    private final TncLog log = new TncLog();

    public BulkInsertHelper(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    private String makeInsertSql() {
        return (this.getIdentityInsertOn() ? " SET IDENTITY_INSERT " + this.getTableName() + " ON " : "") + " INSERT INTO " + this.getTableName() + " (" + ConvertStr.getCommaSeparatedString((String[])this.getColumnsToInsertInto()) + ") VALUES";
    }

    public synchronized void bulkInsert(LoginDto loginDto, List<T> dtoList) throws TncException {
        if (ConvertStr.isNullOrEmpty(dtoList)) {
            return;
        }
        this.dbConnection.getTransactionTemplate(loginDto).executeWithoutResult(transactionStatus -> this.tryInsert(loginDto, dtoList));
    }

    private void tryInsert(LoginDto loginDto, List<T> dtoList) {
        String tableName = this.getTableName();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(loginDto);
        try {
            TransactionCheck.getInstance((DbConnection)this.dbConnection, (String)loginDto.getDatabaseName()).transactionDeadLockWrapper(() -> this.doInsert(loginDto, dtoList), new String[]{tableName});
        }
        catch (Exception e) {
            if (this.getIdentityInsertOn()) {
                SetOffIdentInsert.invoke((TncJdbc)jdbcTemplate, (String)tableName);
            }
            if (ExceptionUtils.noNeedToReInsert((Exception)e)) {
                this.log.error("dbName: " + loginDto.getDatabaseName() + " -* bulkException: " + e);
                throw new TncException(TncExceptionMessages.ERROR_WHILE_INSERTING);
            }
            List allIds = this.getAllIds(dtoList);
            if (allIds != null) {
                String ids = CollectionBinder.builder().trimItems(false).build().wrapThenBind((Collection)allIds);
                String deleteSql = " DELETE FROM " + tableName + " WHERE " + this.getIdFieldName() + " in (" + ids + ")";
                this.log.info("dbName: " + loginDto.getDatabaseName() + " -* bulkDeleteSql: " + deleteSql);
                jdbcTemplate.execute(deleteSql);
                this.bulkInsert(loginDto, dtoList);
            }
            throw e;
        }
    }

    private void doInsert(LoginDto loginDto, List<T> dtoList) {
        String insertSql = this.makeInsertSql();
        StringBuilder sb = new StringBuilder(insertSql);
        int insertBulkCount = 0;
        MyHolooMessageMaker messageMaker = new MyHolooMessageMaker();
        for (T dto : dtoList) {
            if (insertBulkCount >= 50) {
                this.insertFromStringBuilder(loginDto, sb);
                this.resetBulkInsertStr(sb, insertSql);
                insertBulkCount = 0;
            }
            sb.append("(").append(this.appendInsertValues(dto)).append("),");
            ++insertBulkCount;
            if (this.getUpdateState(dto) == null || this.getCodeForWebhook(dto) == null) continue;
            messageMaker.addIfAbsent(this.getCodeForWebhook(dto), this.getUpdateState(dto));
        }
        this.insertFromStringBuilder(loginDto, sb);
        this.callApiResult = this.callApi(loginDto, messageMaker);
    }

    public final List<Map<String, Object>> getCallApiResult() {
        return this.callApiResult;
    }

    @Nullable
    protected List<Map<String, Object>> callApi(LoginDto loginDto, MyHolooMessageMaker messageMaker) {
        return null;
    }

    protected Integer getUpdateState(T dto) {
        return null;
    }

    protected String getCodeForWebhook(T dto) {
        return null;
    }

    protected abstract String getIdFieldName();

    private void resetBulkInsertStr(StringBuilder sb, String insertSql) {
        sb.delete(0, sb.length());
        sb.append(insertSql);
    }

    private void insertFromStringBuilder(LoginDto loginDto, StringBuilder sb) {
        int lastCommaIdx = sb.lastIndexOf(",");
        if (lastCommaIdx > -1) {
            sb.deleteCharAt(lastCommaIdx);
        }
        sb.append(this.getIdentityInsertOn() ? " SET IDENTITY_INSERT " + this.getTableName() + " OFF " : "");
        this.dbConnection.getJdbcTemplate(loginDto).update(sb.toString());
    }

    protected abstract boolean getIdentityInsertOn();

    protected abstract List<String> getAllIds(List<T> var1);

    @Language(value="SQL")
    protected abstract String appendInsertValues(T var1);

    protected abstract String getTableName();

    protected abstract String[] getColumnsToInsertInto();
}

